using System;
using DarkStrideToolbox;



namespace MetalMarines
{
	public class TeamSetup
	{
		#region Properties
		private static string m_cTEAMSETUP_SEP = "[TMS]";

		private long m_nMinFuelSharedPerMinute = 0;
		private long m_nMinCreditsSharedPerMinute = 0;
		private bool m_bSharedVision = true;
		private bool m_bMutualTeamDeparturesRequired = true;
		private string m_sName = "";
		#endregion


		public TeamSetup()
		{
		}


		public string Serialize()
		{
			string sRetVal = "";


			//Now write all the information
			sRetVal = m_nMinFuelSharedPerMinute.ToString() + m_cTEAMSETUP_SEP +
					  m_nMinCreditsSharedPerMinute.ToString() + m_cTEAMSETUP_SEP +
					  m_bSharedVision.ToString() + m_cTEAMSETUP_SEP +
					  m_bMutualTeamDeparturesRequired.ToString() + m_cTEAMSETUP_SEP + 
					  m_sName + m_cTEAMSETUP_SEP;


			return( sRetVal );
		}
		public void DeSerialize( string sRecord )
		{
			string[] saParamaters = null;


			saParamaters = DSMisc.Split( sRecord,m_cTEAMSETUP_SEP );

			//Update this island
			m_nMinFuelSharedPerMinute		= Convert.ToInt16( saParamaters[ 0 ] );
			m_nMinCreditsSharedPerMinute		= Convert.ToInt16( saParamaters[ 1 ] );
			m_bSharedVision					= Convert.ToBoolean( saParamaters[ 2 ] );
			m_bMutualTeamDeparturesRequired	= Convert.ToBoolean( saParamaters[ 3 ] );
			m_sName							= saParamaters[ 4 ];
		}

        

		#region Properties
		public long MinFuelSharedPerMinute
		{
			get
			{
				return( m_nMinFuelSharedPerMinute );
			}
			set
			{
				m_nMinFuelSharedPerMinute = value;
			}
		}
		public long MinCreditsSharedPerMinute
		{
			get
			{
				return( m_nMinCreditsSharedPerMinute );
			}
			set
			{
				m_nMinCreditsSharedPerMinute = value;
			}
		}
		public bool SharedVision
		{
			get
			{
				return( m_bSharedVision );
			}
			set
			{
				m_bSharedVision = value;
			}
		}
		public bool MutualTeamDeparturesRequired
		{
			get
			{
				return( m_bMutualTeamDeparturesRequired );
			}
			set
			{
				m_bMutualTeamDeparturesRequired = value;
			}
		}
		public string Name
		{
			get
			{
				return( m_sName );
			}
			set
			{
				m_sName = value;
			}
		}
		#endregion
	}
}